package com.publiccms.entities.cms;

import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;

import org.hibernate.annotations.DynamicUpdate;

import com.publiccms.common.generator.annotation.GeneratorColumn;

/**
 * CmsDictionary generated by hbm2java
 */
@Entity
@Table(name = "cms_dictionary")
@DynamicUpdate
public class CmsDictionary implements java.io.Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    @GeneratorColumn(title = "ID")
    private CmsDictionaryId id;
    @GeneratorColumn(title = "名称")
    private String name;
    @GeneratorColumn(title = "允许多选", condition = true)
    private boolean multiple;

    public CmsDictionary() {
    }

    public CmsDictionary(CmsDictionaryId id, String name, boolean multiple) {
        this.id = id;
        this.name = name;
        this.multiple = multiple;
    }

    @EmbeddedId
    @AttributeOverrides({ @AttributeOverride(name = "id", column = @Column(name = "id", nullable = false, length = 20)),
            @AttributeOverride(name = "siteId", column = @Column(name = "site_id", nullable = false)) })
    public CmsDictionaryId getId() {
        return this.id;
    }

    public void setId(CmsDictionaryId id) {
        this.id = id;
    }

    @Column(name = "name", nullable = false, length = 100)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "multiple", nullable = false)
    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

}
