package com.publiccms.entities.log;
// Generated 2021-1-14 22:33:12 by Hibernate Tools 6.0.0-SNAPSHOT

import java.util.Date;

import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.DynamicUpdate;

import com.publiccms.common.generator.annotation.GeneratorColumn;

/**
 * LogVisitSession generated by hbm2java
 */
@Entity
@Table(name = "log_visit_session")
@DynamicUpdate
public class LogVisitSession implements java.io.Serializable {

    /**
    *
    */
    private static final long serialVersionUID = 1L;

    @GeneratorColumn(title = "ID")
    private LogVisitSessionId id;
    @GeneratorColumn(title = "上次访问时间", order = true)
    private Date lastVisitDate;
    @GeneratorColumn(title = "首次访问时间")
    private Date firstVisitDate;
    @GeneratorColumn(title = "IP", condition = true)
    private String ip;
    @GeneratorColumn(title = "PV")
    private long pv;

    public LogVisitSession() {
    }

    public LogVisitSession(LogVisitSessionId id, String ip, long pv) {
        this.id = id;
        this.ip = ip;
        this.pv = pv;
    }

    public LogVisitSession(short siteId, String sessionId, Date visitDate, Date lastVisitDate, Date firstVisitDate, String ip,
            long pv) {
        this.id = new LogVisitSessionId(siteId, sessionId, visitDate);
        this.lastVisitDate = lastVisitDate;
        this.firstVisitDate = firstVisitDate;
        this.ip = ip;
        this.pv = pv;
    }

    @EmbeddedId
    @AttributeOverrides({ @AttributeOverride(name = "siteId", column = @Column(name = "site_id", nullable = false)),
            @AttributeOverride(name = "sessionId", column = @Column(name = "session_id", nullable = false, length = 50)),
            @AttributeOverride(name = "visitDate", column = @Column(name = "visit_date", nullable = false, length = 10)) })
    public LogVisitSessionId getId() {
        return this.id;
    }

    public void setId(LogVisitSessionId id) {
        this.id = id;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "last_visit_date", length = 19)
    public Date getLastVisitDate() {
        return this.lastVisitDate;
    }

    public void setLastVisitDate(Date lastVisitDate) {
        this.lastVisitDate = lastVisitDate;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "first_visit_date", length = 19)
    public Date getFirstVisitDate() {
        return this.firstVisitDate;
    }

    public void setFirstVisitDate(Date firstVisitDate) {
        this.firstVisitDate = firstVisitDate;
    }

    @Column(name = "ip", nullable = false, length = 130)
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    @Column(name = "pv", nullable = false)
    public long getPv() {
        return this.pv;
    }

    public void setPv(long pv) {
        this.pv = pv;
    }

}
