package com.publiccms.entities.sys;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.publiccms.common.database.CmsUpgrader;
import com.publiccms.common.generator.annotation.GeneratorColumn;

/**
 * SysDept generated by hbm2java
 */
@Entity
@Table(name = "sys_dept")
@DynamicUpdate
public class SysDept implements java.io.Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    @GeneratorColumn(title = "ID")
    private Integer id;
    @GeneratorColumn(title = "站点", condition = true)
    @JsonIgnore
    private short siteId;
    @GeneratorColumn(title = "名称", condition = true, like = true)
    private String name;
    @GeneratorColumn(title = "父部门", condition = true)
    private Integer parentId;
    @GeneratorColumn(title = "描述")
    private String description;
    @GeneratorColumn(title = "负责人", condition = true)
    private Long userId;
    @GeneratorColumn(title = "最大内容置顶级别")
    private int maxSort;
    @GeneratorColumn(title = "拥有全部分类")
    private boolean ownsAllCategory;
    @GeneratorColumn(title = "拥有全部页面")
    private boolean ownsAllPage;
    @GeneratorColumn(title = "拥有全部配置")
    private boolean ownsAllConfig;

    public SysDept() {
    }

    public SysDept(short siteId, String name, int maxSort, boolean ownsAllCategory, boolean ownsAllPage, boolean ownsAllConfig) {
        this.siteId = siteId;
        this.name = name;
        this.maxSort = maxSort;
        this.ownsAllCategory = ownsAllCategory;
        this.ownsAllPage = ownsAllPage;
        this.ownsAllConfig = ownsAllConfig;
    }

    public SysDept(short siteId, String name, Integer parentId, String description, Long userId, int maxSort, boolean ownsAllCategory,
            boolean ownsAllPage, boolean ownsAllConfig) {
        this.siteId = siteId;
        this.name = name;
        this.parentId = parentId;
        this.description = description;
        this.userId = userId;
        this.maxSort = maxSort;
        this.ownsAllCategory = ownsAllCategory;
        this.ownsAllPage = ownsAllPage;
        this.ownsAllConfig = ownsAllConfig;
    }

    @Id
    @GeneratedValue(generator = "cmsGenerator")
    @GenericGenerator(name = "cmsGenerator", strategy = CmsUpgrader.IDENTIFIER_GENERATOR)
    @Column(name = "id", unique = true, nullable = false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name = "site_id", nullable = false)
    public short getSiteId() {
        return this.siteId;
    }

    public void setSiteId(short siteId) {
        this.siteId = siteId;
    }

    @Column(name = "name", nullable = false, length = 50)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "parent_id")
    public Integer getParentId() {
        return this.parentId;
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    @Column(name = "description", length = 300)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name = "user_id")
    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Column(name = "max_sort", nullable = false)
    public int getMaxSort() {
        return this.maxSort;
    }

    public void setMaxSort(int maxSort) {
        this.maxSort = maxSort;
    }
    
    @Column(name = "owns_all_category", nullable = false)
    public boolean isOwnsAllCategory() {
        return this.ownsAllCategory;
    }

    public void setOwnsAllCategory(boolean ownsAllCategory) {
        this.ownsAllCategory = ownsAllCategory;
    }

    @Column(name = "owns_all_page", nullable = false)
    public boolean isOwnsAllPage() {
        return this.ownsAllPage;
    }

    public void setOwnsAllPage(boolean ownsAllPage) {
        this.ownsAllPage = ownsAllPage;
    }

    @Column(name = "owns_all_config", nullable = false)
    public boolean isOwnsAllConfig() {
        return this.ownsAllConfig;
    }

    public void setOwnsAllConfig(boolean ownsAllConfig) {
        this.ownsAllConfig = ownsAllConfig;
    }
}
