package com.publiccms.entities.sys;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.publiccms.common.database.CmsUpgrader;
import com.publiccms.common.generator.annotation.GeneratorColumn;

/**
 * SysRole generated by hbm2java
 */
@Entity
@Table(name = "sys_role")
@DynamicUpdate
public class SysRole implements java.io.Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    @GeneratorColumn(title = "ID")
    private Integer id;
    @GeneratorColumn(title = "站点", condition = true)
    @JsonIgnore
    private short siteId;
    @GeneratorColumn(title = "名称")
    private String name;
    @GeneratorColumn(title = "拥有全部权限")
    private boolean ownsAllRight;
    @GeneratorColumn(title = "显示全部模块")
    private boolean showAllModule;

    public SysRole() {
    }

    public SysRole(short siteId, String name, boolean ownsAllRight, boolean showAllModule) {
        this.siteId = siteId;
        this.name = name;
        this.ownsAllRight = ownsAllRight;
        this.showAllModule = showAllModule;
    }

    @Id
    @GeneratedValue(generator = "cmsGenerator")
    @GenericGenerator(name = "cmsGenerator", strategy = CmsUpgrader.IDENTIFIER_GENERATOR)
    @Column(name = "id", unique = true, nullable = false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name = "site_id", nullable = false)
    public short getSiteId() {
        return this.siteId;
    }

    public void setSiteId(short siteId) {
        this.siteId = siteId;
    }

    @Column(name = "name", nullable = false, length = 50)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "owns_all_right", nullable = false)
    public boolean isOwnsAllRight() {
        return this.ownsAllRight;
    }

    public void setOwnsAllRight(boolean ownsAllRight) {
        this.ownsAllRight = ownsAllRight;
    }

    @Column(name = "show_all_module", nullable = false)
    public boolean isShowAllModule() {
        return this.showAllModule;
    }

    public void setShowAllModule(boolean showAllModule) {
        this.showAllModule = showAllModule;
    }

}
