package com.publiccms.entities.log;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.publiccms.common.database.CmsUpgrader;
import com.publiccms.common.generator.annotation.GeneratorColumn;

/**
 * LogLogin generated by hbm2java
 */
@Entity
@Table(name = "log_login")
@DynamicUpdate
public class LogLogin implements java.io.Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    @GeneratorColumn(title = "ID")
    private Long id;
    @GeneratorColumn(title = "站点", condition = true)
    @JsonIgnore
    private short siteId;
    /**
     * name<p>
     * 用户名
     */
    @GeneratorColumn(title = "用户名", condition = true, like = true)
    @Length(max = 50)
    private String name;
    /**
     * user id<p>
     * 用户id
     */
    @GeneratorColumn(title = "用户", condition = true)
    private Long userId;
    /**
     * ip
     */
    @GeneratorColumn(title = "IP", condition = true, like = true)
    private String ip;
    /**
     * login channel<p>
     * 登录渠道
     */
    @GeneratorColumn(title = "登录渠道", condition = true)
    private String channel;
    /**
     * login method<p>
     * 登录方式
     */
    @GeneratorColumn(title = "登录方式", condition = true)
    private String loginMethod;
    /**
     * login result<p>
     * 登录结果
     */
    @GeneratorColumn(title = "登录结果", condition = true)
    private boolean result;
    /**
     * login date<p>
     * 登录日期
     */
    @GeneratorColumn(title = "登录日期", condition = true, order = true)
    private Date createDate;
    /**
     * error password<p>
     * 错误密码
     */
    @GeneratorColumn(title = "错误密码")
    private String errorPassword;

    public LogLogin() {
    }

    public LogLogin(short siteId, String name, String ip, String channel, String loginMethod, boolean result, Date createDate) {
        this.siteId = siteId;
        this.name = name;
        this.ip = ip;
        this.channel = channel;
        this.loginMethod = loginMethod;
        this.result = result;
        this.createDate = createDate;
    }

    public LogLogin(short siteId, String name, Long userId, String ip, String channel, String loginMethod, boolean result, Date createDate,
            String errorPassword) {
        this.siteId = siteId;
        this.name = name;
        this.userId = userId;
        this.ip = ip;
        this.channel = channel;
        this.loginMethod = loginMethod;
        this.result = result;
        this.createDate = createDate;
        this.errorPassword = errorPassword;
    }

    @Id
    @GeneratedValue(generator = "cmsGenerator")
    @GenericGenerator(name = "cmsGenerator", strategy = CmsUpgrader.IDENTIFIER_GENERATOR)
    @Column(name = "id", unique = true, nullable = false)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "site_id", nullable = false)
    public short getSiteId() {
        return this.siteId;
    }

    public void setSiteId(short siteId) {
        this.siteId = siteId;
    }

    @Column(name = "name", nullable = false, length = 50)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "user_id")
    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Column(name = "ip", nullable = false, length = 130)
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    @Column(name = "channel", nullable = false, length = 50)
    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    @Column(name = "login_method", nullable = false, length = 50)
    public String getLoginMethod() {
        return this.loginMethod;
    }

    public void setLoginMethod(String loginMethod) {
        this.loginMethod = loginMethod;
    }

    @Column(name = "result", nullable = false)
    public boolean isResult() {
        return this.result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_date", nullable = false, length = 19)
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @Column(name = "error_password")
    public String getErrorPassword() {
        return this.errorPassword;
    }

    public void setErrorPassword(String errorPassword) {
        this.errorPassword = errorPassword;
    }

}
