package com.publiccms.entities.sys;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.publiccms.common.database.CmsUpgrader;
import com.publiccms.common.generator.annotation.GeneratorColumn;

/**
 * SysApp generated by hbm2java
 */
@Entity
@Table(name = "sys_app", uniqueConstraints = @UniqueConstraint(columnNames = "app_key"))
@DynamicUpdate
public class SysApp implements java.io.Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    @GeneratorColumn(title = "ID")
    private Integer id;
    @GeneratorColumn(title = "站点", condition = true)
    @JsonIgnore
    private short siteId;
    /**
     * channel<p>
     * 渠道
     */
    @GeneratorColumn(title = "渠道", condition = true)
    private String channel;
    /**
     * app key<p>
     * 授权key
     */
    @GeneratorColumn(title = "授权KEY")
    private String appKey;
    /**
     * app secret<p>
     * 授权密钥
     */
    @JsonIgnore
    @GeneratorColumn(title = "授权密码")
    private String appSecret;
    /**
     * authorized apis<p>
     * 授权接口
     */
    @GeneratorColumn(title = "授权接口")
    private String authorizedApis;
    /**
     * expiry minutes<p>
     * 过期分钟数
     */
    @GeneratorColumn(title = "过期时间")
    private Integer expiryMinutes;

    public SysApp() {
    }

    public SysApp(short siteId, String channel, String appKey, String appSecret) {
        this.siteId = siteId;
        this.channel = channel;
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public SysApp(short siteId, String channel, String appKey, String appSecret, String authorizedApis, Integer expiryMinutes) {
        this.siteId = siteId;
        this.channel = channel;
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.authorizedApis = authorizedApis;
        this.expiryMinutes = expiryMinutes;
    }

    @Id
    @GeneratedValue(generator = "cmsGenerator")
    @GenericGenerator(name = "cmsGenerator", strategy = CmsUpgrader.IDENTIFIER_GENERATOR)
    @Column(name = "id", unique = true, nullable = false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name = "site_id", nullable = false)
    public short getSiteId() {
        return this.siteId;
    }

    public void setSiteId(short siteId) {
        this.siteId = siteId;
    }

    @Column(name = "channel", nullable = false, length = 50)
    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    @Column(name = "app_key", unique = true, nullable = false, length = 50)
    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    @Column(name = "app_secret", nullable = false, length = 50)
    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    @Column(name = "authorized_apis", length = 65535)
    public String getAuthorizedApis() {
        return this.authorizedApis;
    }

    public void setAuthorizedApis(String authorizedApis) {
        this.authorizedApis = authorizedApis;
    }

    @Column(name = "expiry_minutes")
    public Integer getExpiryMinutes() {
        return this.expiryMinutes;
    }

    public void setExpiryMinutes(Integer expiryMinutes) {
        this.expiryMinutes = expiryMinutes;
    }

}
