package com.publiccms.entities.sys;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.publiccms.common.database.CmsUpgrader;
import com.publiccms.common.generator.annotation.GeneratorColumn;
import com.publiccms.views.pojo.entities.EntityAttribute;

/**
 * SysUser generated by hbm2java
 */
@Entity
@Table(name = "sys_user", uniqueConstraints = { @UniqueConstraint(columnNames = { "name", "site_id" }) })
@DynamicUpdate
public class SysUser extends EntityAttribute implements java.io.Serializable {
    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    @GeneratorColumn(title = "ID")
    private Long id;
    @GeneratorColumn(title = "站点", condition = true)
    @JsonIgnore
    private short siteId;
    /**
     * name
     * 
     * 用户名
     */
    @GeneratorColumn(title = "用户名", condition = true, like = true, or = true, name = "name")
    @NotNull
    @Length(max = 50)
    private String name;
    @GeneratorColumn(title = "密码")
    @JsonIgnore
    private String password;
    /**
     * weak password
     * 
     * 弱密码
     */
    @GeneratorColumn(title = "弱密码", condition = true)
    private boolean weakPassword;
    /**
     * nickname
     * 
     * 昵称
     */
    @GeneratorColumn(title = "用户昵称", condition = true, like = true, or = true, name = "name")
    @NotBlank
    private String nickname;
    /**
     * cover
     * 
     * 封面图
     */
    @GeneratorColumn(title = "封面图")
    private String cover;
    /**
     * dept id
     * 
     * 部门id
     */
    @GeneratorColumn(title = "部门", condition = true)
    private Integer deptId;
    /**
     * content permissions(0:self,1:all,2:dept)
     * 
     * 内容权限(0:自己的,1:全部,2:本部门)
     */
    @GeneratorColumn(title = "内容权限")
    private int contentPermissions;
    /**
     * role ids
     * 
     * 角色id
     */
    @GeneratorColumn(title = "角色")
    private String roles;
    /**
     * email
     * 
     * 邮件地址
     */
    @GeneratorColumn(title = "邮箱", condition = true, like = true, or = true, name = "name")
    private String email;
    /**
     * email checked
     * 
     * 已验证邮件
     */
    @GeneratorColumn(title = "已验证邮箱", condition = true)
    private boolean emailChecked;
    /**
     * super user
     * 
     * 管理员
     */
    @GeneratorColumn(title = "是否管理员", condition = true)
    private boolean superuser;

    /**
     * disabled
     * 
     * 已禁用p
     */
    @GeneratorColumn(title = "已禁用", condition = true)
    @JsonIgnore
    private boolean disabled;
    /**
     * last login date
     * 
     * 上次登录日期
     */
    @GeneratorColumn(title = "上次登录日期", condition = true, order = true)
    private Date lastLoginDate;
    /**
     * last login ip
     * 
     * 上次登录ip
     */
    @GeneratorColumn(title = "上次登录IP")
    private String lastLoginIp;
    /**
     * login count
     * 
     * 登录次数
     */
    @GeneratorColumn(title = "登录次数", order = true)
    private int loginCount;
    /**
     * register date
     * 
     * 注册日期
     */
    @GeneratorColumn(title = "注册日期", condition = true, order = true)
    private Date registeredDate;
    /**
     * update date
     * <p>
     * 更新日期
     */
    @GeneratorColumn(title = "更新日期")
    private Date updateDate;

    public SysUser() {
    }

    public SysUser(short siteId, String name, String password, boolean weakPassword, String nickname, int contentPermissions,
            boolean emailChecked, boolean superuser, boolean disabled, int loginCount) {
        this.siteId = siteId;
        this.name = name;
        this.password = password;
        this.weakPassword = weakPassword;
        this.nickname = nickname;
        this.contentPermissions = contentPermissions;
        this.emailChecked = emailChecked;
        this.superuser = superuser;
        this.disabled = disabled;
        this.loginCount = loginCount;
    }

    public SysUser(short siteId, String name, String password, boolean weakPassword, String nickname, String cover,
            Integer deptId, int contentPermissions, String roles, String email, boolean emailChecked, boolean superuser,
            Date registeredDate) {
        this(siteId, name, password, weakPassword, nickname, cover, deptId, contentPermissions, roles, email, emailChecked,
                superuser, false, null, null, 0, registeredDate, null);
    }

    public SysUser(short siteId, String name, String password, boolean weakPassword, String nickname, String cover,
            Integer deptId, int contentPermissions, String roles, String email, boolean emailChecked, boolean superuser,
            boolean disabled, Date lastLoginDate, String lastLoginIp, int loginCount, Date registeredDate, Date updateDate) {
        this.siteId = siteId;
        this.name = name;
        this.password = password;
        this.weakPassword = weakPassword;
        this.nickname = nickname;
        this.cover = cover;
        this.deptId = deptId;
        this.contentPermissions = contentPermissions;
        this.roles = roles;
        this.email = email;
        this.emailChecked = emailChecked;
        this.superuser = superuser;
        this.disabled = disabled;
        this.lastLoginDate = lastLoginDate;
        this.lastLoginIp = lastLoginIp;
        this.loginCount = loginCount;
        this.registeredDate = registeredDate;
        this.updateDate = updateDate;
    }

    @Id
    @GeneratedValue(generator = "cmsGenerator")
    @GenericGenerator(name = "cmsGenerator", strategy = CmsUpgrader.IDENTIFIER_GENERATOR)
    @Column(name = "id", unique = true, nullable = false)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "site_id", nullable = false)
    public short getSiteId() {
        return this.siteId;
    }

    public void setSiteId(short siteId) {
        this.siteId = siteId;
    }

    @Column(name = "name", nullable = false, length = 50)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "password", nullable = false, length = 150)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Column(name = "weak_password", nullable = false)
    public boolean isWeakPassword() {
        return this.weakPassword;
    }

    public void setWeakPassword(boolean weakPassword) {
        this.weakPassword = weakPassword;
    }

    @Column(name = "nickname", nullable = false, length = 45)
    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    @Column(name = "cover")
    public String getCover() {
        return this.cover;
    }

    public void setCover(String cover) {
        this.cover = cover;
    }

    @Column(name = "dept_id")
    public Integer getDeptId() {
        return this.deptId;
    }

    public void setDeptId(Integer deptId) {
        this.deptId = deptId;
    }

    @Column(name = "content_permissions", nullable = false)
    public int getContentPermissions() {
        return this.contentPermissions;
    }

    public void setContentPermissions(int contentPermissions) {
        this.contentPermissions = contentPermissions;
    }

    @Column(name = "roles", length = 65535)
    public String getRoles() {
        return this.roles;
    }

    public void setRoles(String roles) {
        this.roles = roles;
    }

    @Column(name = "email", length = 100)
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Column(name = "email_checked", nullable = false)
    public boolean isEmailChecked() {
        return this.emailChecked;
    }

    public void setEmailChecked(boolean emailChecked) {
        this.emailChecked = emailChecked;
    }

    @Column(name = "superuser", nullable = false)
    public boolean isSuperuser() {
        return this.superuser;
    }

    public void setSuperuser(boolean superuser) {
        this.superuser = superuser;
    }

    @Column(name = "disabled", nullable = false)
    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "last_login_date", length = 19)
    public Date getLastLoginDate() {
        return this.lastLoginDate;
    }

    public void setLastLoginDate(Date lastLoginDate) {
        this.lastLoginDate = lastLoginDate;
    }

    @Column(name = "last_login_ip", length = 130)
    public String getLastLoginIp() {
        return this.lastLoginIp;
    }

    public void setLastLoginIp(String lastLoginIp) {
        this.lastLoginIp = lastLoginIp;
    }

    @Column(name = "login_count", nullable = false)
    public int getLoginCount() {
        return this.loginCount;
    }

    public void setLoginCount(int loginCount) {
        this.loginCount = loginCount;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "registered_date", length = 19)
    public Date getRegisteredDate() {
        return this.registeredDate;
    }

    public void setRegisteredDate(Date registeredDate) {
        this.registeredDate = registeredDate;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_date", length = 19)
    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }
}
