package com.publiccms.entities.sys;
// Generated 2023-8-7 21:42:23 by Hibernate Tools 5.6.15.Final

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.publiccms.common.database.CmsUpgrader;
import com.publiccms.common.generator.annotation.GeneratorColumn;

/**
 * SysWorkflow generated by hbm2java
 */
@Entity
@Table(name = "sys_workflow")
@DynamicUpdate
public class SysWorkflow implements java.io.Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    @GeneratorColumn(title = "ID")
    private Integer id;
    @GeneratorColumn(title = "站点", condition = true)
    @JsonIgnore
    private short siteId;
    /**
     * name
     * 名称
     */
    @GeneratorColumn(title = "名称", condition = true, like = true, or = true, name = "name")
    @NotNull
    @Length(max = 100)
    private String name;
    /**
     * description
     * 描述
     */
    @Length(max = 300)
    @GeneratorColumn(title = "描述", condition = true, like = true, or = true, name = "name")
    private String description;
    /**
     * start step
     * <p>
     * 开始步骤
     */
    @GeneratorColumn(title = "开始步骤")
    private Long startStepId;
    @GeneratorColumn(title = "已禁用", condition = true)
    @JsonIgnore
    private boolean disabled;
    /**
     * create date
     * <p>
     * 创建日期
     */
    @GeneratorColumn(title = "创建日期")
    private Date createDate;

    public SysWorkflow() {
    }

    public SysWorkflow(short siteId, String name, boolean disabled, Date createDate) {
        this.siteId = siteId;
        this.name = name;
        this.disabled = disabled;
        this.createDate = createDate;
    }

    public SysWorkflow(short siteId, String name, String description, Long startStepId, boolean disabled, Date createDate) {
        this.siteId = siteId;
        this.name = name;
        this.description = description;
        this.startStepId = startStepId;
        this.disabled = disabled;
        this.createDate = createDate;
    }

    @Id
    @GeneratedValue(generator = "cmsGenerator")
    @GenericGenerator(name = "cmsGenerator", strategy = CmsUpgrader.IDENTIFIER_GENERATOR)
    @Column(name = "id", unique = true, nullable = false)
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Column(name = "site_id", nullable = false)
    public short getSiteId() {
        return this.siteId;
    }

    public void setSiteId(short siteId) {
        this.siteId = siteId;
    }

    @Column(name = "name", nullable = false, length = 100)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "description", length = 300)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name = "start_step_id")
    public Long getStartStepId() {
        return this.startStepId;
    }

    public void setStartStepId(Long startStepId) {
        this.startStepId = startStepId;
    }

    @Column(name = "disabled", nullable = false)
    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_date", nullable = false, length = 19)
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
}
