package com.publiccms.entities.sys;

import java.util.Date;

import org.hibernate.annotations.DynamicUpdate;

import com.publiccms.common.generator.annotation.GeneratorColumn;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
/**
 * SysUserAttribute generated by hbm2java
 */
@Entity
@Table(name = "sys_user_attribute")
@DynamicUpdate
public class SysUserAttribute implements java.io.Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    @GeneratorColumn(title = "用户")
    private long userId;
    @GeneratorColumn(title = "扩展数据")
    private String data;
    /**
     * create date
     * 
     * 创建日期
     */
    @GeneratorColumn(title = "创建日期")
    private Date createDate;
    /**
     * update date
     * 
     * 更新日期
     */
    @GeneratorColumn(title = "更新日期")
    private Date updateDate;

    public SysUserAttribute() {
    }

    public SysUserAttribute(long userId) {
        this.userId = userId;
    }

    public SysUserAttribute(long userId, String data, Date createDate) {
        this.userId = userId;
        this.data = data;
        this.createDate = createDate;
    }

    public SysUserAttribute(long userId, String data, Date createDate, Date updateDate) {
        this.userId = userId;
        this.data = data;
        this.createDate = createDate;
        this.updateDate = updateDate;
    }

    @Id
    @Column(name = "user_id", unique = true, nullable = false)
    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    @Column(name = "data")
    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    @Column(name = "create_date", nullable = false, length = 19)
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @Column(name = "update_date", length = 19)
    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

}