package com.publiccms.entities.log;

import java.util.Date;

import org.hibernate.annotations.DynamicUpdate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.publiccms.common.generator.annotation.GeneratorColumn;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;

/**
 * LogOperate generated by hbm2java
 */
@Entity
@Table(name = "log_operate")
@DynamicUpdate
public class LogOperate implements java.io.Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    @GeneratorColumn(title = "ID")
    private Long id;
    @GeneratorColumn(title = "站点", condition = true)
    @JsonIgnore
    private short siteId;
    /**
     * user id<p>
     * 用户id
     */
    @GeneratorColumn(title = "用户", condition = true)
    private Long userId;
    /**
     * dept id<p>
     * 部门id
     */
    @GeneratorColumn(title = "部门", condition = true)
    private Integer deptId;
    /**
     * channel<p>
     * 渠道
     */
    @GeneratorColumn(title = "渠道", condition = true)
    private String channel;
    /**
     * operate channel<p>
     * 操作渠道
     */
    @GeneratorColumn(title = "操作", condition = true)
    private String operate;
    /**
     * ip
     */
    @GeneratorColumn(title = "IP", condition = true)
    private String ip;
    /**
     * operate date<p>
     * 操作日期
     */
    @GeneratorColumn(title = "操作日期", condition = true, order = true)
    private Date createDate;
    /**
     * content<p>
     * 内容
     */
    @GeneratorColumn(title = "内容", condition = true, like = true)
    private String content;

    public LogOperate() {
    }

    public LogOperate(short siteId, String channel, String operate, Date createDate, String content) {
        this.siteId = siteId;
        this.channel = channel;
        this.operate = operate;
        this.createDate = createDate;
        this.content = content;
    }

    public LogOperate(short siteId, Long userId, Integer deptId, String channel, String operate, String ip, Date createDate,
            String content) {
        this.siteId = siteId;
        this.userId = userId;
        this.deptId = deptId;
        this.channel = channel;
        this.operate = operate;
        this.ip = ip;
        this.createDate = createDate;
        this.content = content;
    }

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id", unique = true, nullable = false)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "site_id", nullable = false)
    public short getSiteId() {
        return this.siteId;
    }

    public void setSiteId(short siteId) {
        this.siteId = siteId;
    }

    @Column(name = "user_id")
    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Column(name = "dept_id")
    public Integer getDeptId() {
        return this.deptId;
    }

    public void setDeptId(Integer deptId) {
        this.deptId = deptId;
    }

    @Column(name = "channel", nullable = false, length = 50)
    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    @Column(name = "operate", nullable = false, length = 40)
    public String getOperate() {
        return this.operate;
    }

    public void setOperate(String operate) {
        this.operate = operate;
    }

    @Column(name = "ip", length = 130)
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    @Column(name = "create_date", nullable = false, length = 19)
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @Column(name = "content", length = 65535)
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

}
