package com.publiccms.entities.sys;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.publiccms.common.generator.annotation.GeneratorColumn;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.constraints.NotNull;

/**
 * SysSite generated by hbm2java
 */
@Entity
@Table(name = "sys_site", uniqueConstraints = @UniqueConstraint(columnNames = { "parent_id", "directory" }))
@DynamicUpdate
public class SysSite implements java.io.Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    @GeneratorColumn(title = "ID")
    private Short id;
    /**
     * parent site id
     * <p>
     * 父站点id
     */
    @GeneratorColumn(title = "父站点", condition = true)
    private Short parentId;
    /**
     * directory
     * <p>
     * 目录
     */
    @GeneratorColumn(title = "目录")
    @Length(max = 50)
    private String directory;
    /**
     * name
     * <p>
     * 名称
     */
    @GeneratorColumn(title = "名称", condition = true, like = true)
    @NotNull
    @Length(max = 50)
    private String name;
    /**
     * use static
     * <p>
     * 启用静态化
     */
    @GeneratorColumn(title = "启用静态化")
    private boolean useStatic;
    /**
     * site url
     * <p>
     * 静态站点地址
     */
    @GeneratorColumn(title = "站点地址")
    @NotNull
    @Length(max = 255)
    private String sitePath;
    /**
     * use SSI
     * <p>
     * 启用服务器端包含
     */
    @GeneratorColumn(title = "启用SSI")
    private boolean useSsi;
    /**
     * dynamic site url
     * <p>
     * 动态站点地址
     */
    @GeneratorColumn(title = "动态站点地址")
    @NotNull
    @Length(max = 255)
    private String dynamicPath;

    /**
     * has child site
     * <p>
     * 拥有子站点
     */
    @GeneratorColumn(title = "拥有子站点")
    private boolean hasChild;
    /**
     * multiple site
     * <p>
     * 站群
     */
    @GeneratorColumn(title = "站群")
    private boolean multiple;
    @GeneratorColumn(title = "禁用", condition = true)
    @JsonIgnore
    private boolean disabled;

    public SysSite() {
    }

    public SysSite(String name, boolean useStatic, String sitePath, boolean useSsi, String dynamicPath, boolean hasChild,
            boolean multiple, boolean disabled) {
        this.name = name;
        this.useStatic = useStatic;
        this.sitePath = sitePath;
        this.useSsi = useSsi;
        this.dynamicPath = dynamicPath;
        this.hasChild = hasChild;
        this.multiple = multiple;
        this.disabled = disabled;
    }

    public SysSite(Short parentId, String directory, String name, boolean useStatic, String sitePath, boolean useSsi,
            String dynamicPath, boolean hasChild, boolean multiple, boolean disabled) {
        this.parentId = parentId;
        this.directory = directory;
        this.name = name;
        this.useStatic = useStatic;
        this.sitePath = sitePath;
        this.useSsi = useSsi;
        this.dynamicPath = dynamicPath;
        this.hasChild = hasChild;
        this.multiple = multiple;
        this.disabled = disabled;
    }

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id", unique = true, nullable = false)
    public Short getId() {
        return this.id;
    }

    public void setId(Short id) {
        this.id = id;
    }

    @Column(name = "parent_id")
    public Short getParentId() {
        return this.parentId;
    }

    public void setParentId(Short parentId) {
        this.parentId = parentId;
    }

    @Column(name = "directory", length = 50)
    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Column(name = "name", nullable = false, length = 50)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "use_static", nullable = false)
    public boolean isUseStatic() {
        return this.useStatic;
    }

    public void setUseStatic(boolean useStatic) {
        this.useStatic = useStatic;
    }

    @Column(name = "site_path", nullable = false)
    public String getSitePath() {
        return this.sitePath;
    }

    public void setSitePath(String sitePath) {
        this.sitePath = sitePath;
    }

    @Column(name = "use_ssi", nullable = false)
    public boolean isUseSsi() {
        return this.useSsi;
    }

    public void setUseSsi(boolean useSsi) {
        this.useSsi = useSsi;
    }

    @Column(name = "dynamic_path", nullable = false)
    public String getDynamicPath() {
        return this.dynamicPath;
    }

    public void setDynamicPath(String dynamicPath) {
        this.dynamicPath = dynamicPath;
    }

    @Column(name = "has_child", nullable = false)
    public boolean isHasChild() {
        return this.hasChild;
    }

    public void setHasChild(boolean hasChild) {
        this.hasChild = hasChild;
    }

    @Column(name = "multiple", nullable = false)
    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    @Column(name = "disabled", nullable = false)
    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }
}
