package com.publiccms.entities.sys;

import java.util.Date;

import org.hibernate.annotations.DynamicUpdate;

import com.publiccms.common.generator.annotation.GeneratorColumn;

import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;

/**
 * SysUserSetting generated by hbm2java
 */
@Entity
@Table(name = "sys_user_setting")
@DynamicUpdate
public class SysUserSetting implements java.io.Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    @GeneratorColumn(title = "ID")
    private SysUserSettingId id;
    /**
     * setting data
     * <p>
     * 配置数据
     */
    @GeneratorColumn(title = "值")
    private String data;
    /**
     * create date
     * 
     * 创建日期
     */
    @GeneratorColumn(title = "创建日期")
    private Date createDate;
    /**
     * update date
     * 
     * 更新日期
     */
    @GeneratorColumn(title = "更新日期")
    private Date updateDate;

    public SysUserSetting() {
    }

    public SysUserSetting(SysUserSettingId id, String data, Date createDate) {
        this.id = id;
        this.data = data;
        this.createDate = createDate;
    }

    public SysUserSetting(SysUserSettingId id, String data, Date createDate, Date updateDate) {
        this.id = id;
        this.data = data;
        this.createDate = createDate;
        this.updateDate = updateDate;
    }

    @EmbeddedId

    @AttributeOverrides({ @AttributeOverride(name = "userId", column = @Column(name = "user_id", nullable = false)),
            @AttributeOverride(name = "code", column = @Column(name = "code", nullable = false, length = 50)) })
    public SysUserSettingId getId() {
        return this.id;
    }

    public void setId(SysUserSettingId id) {
        this.id = id;
    }

    @Column(name = "data", nullable = false)
    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    @Column(name = "create_date", nullable = false, length = 19)
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @Column(name = "update_date", length = 19)
    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }
}
