package com.publiccms.entities.trade;
// Generated 2021-6-26 20:07:40 by Hibernate Tools 6.0.0-SNAPSHOT

import java.math.BigDecimal;
import java.util.Date;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.publiccms.common.generator.annotation.GeneratorColumn;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;

/**
 * TradeProductOrder generated by hbm2java
 */
@Entity
@Table(name = "trade_order")
@DynamicUpdate
public class TradeOrder implements java.io.Serializable {

    /**
    *
    */
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @GeneratorColumn(title = "ID")
    private Long id;
    @GeneratorColumn(title = "站点", condition = true)
    @JsonIgnore
    private short siteId;
    /**
     * user id<p>
     * 用户id
     */
    @GeneratorColumn(title = "用户", condition = true)
    private long userId;
    /**
     * title<p>
     * 标题
     */
    @GeneratorColumn(title = "标题", condition = true, like = true)
    @Length(max = 255)
    private String title;
    /**
     * amount<p>
     * 金额
     */
    @GeneratorColumn(title = "总金额")
    private BigDecimal amount;
    /**
     * payment id<p>
     * 支付订单id
     */
    @GeneratorColumn(title = "支付", condition = true)
    private Long paymentId;
    /**
     * address<p>
     * 收货地址
     */
    @GeneratorColumn(title = "收货地址")
    private String address;
    /**
     * addressee<p>
     * 收件人
     */
    @GeneratorColumn(title = "收件人")
    private String addressee;
    /**
     * telphone<p>
     * 电话
     */
    @GeneratorColumn(title = "电话")
    private String telephone;
    /**
     * ip
     */
    @GeneratorColumn(title = "IP")
    private String ip;
    /**
     * remark<p>
     * 备注
     */
    @GeneratorColumn(title = "备注")
    private String remark;
    /**
     * status(0:pending,1:invalid,2:paid,3:refunded,4:close)<p>
     * 状态(0:待处理,1:无效订单,2:已支付,3:已退款,4:已关闭)
     */
    @GeneratorColumn(title = "订单状态", condition = true)
    private int status;
    /**
     * confirmed<p>
     * 是否确认
     */
    @GeneratorColumn(title = "是否确认", condition = true)
    private boolean confirmed;
    /**
     * processed<p>
     * 是否处理
     */
    @GeneratorColumn(title = "是否处理", condition = true)
    private boolean processed;
    /**
     * process user id<p>
     * 处理用户id
     */
    @GeneratorColumn(title = "处理用户")
    private Long processUserId;
    /**
     * process info<p>
     * 处理信息
     */
    @GeneratorColumn(title = "处理信息")
    private String processInfo;
    /**
     * update date<p>
     * 更新日期
     */
    @GeneratorColumn(title = "更新日期")
    private Date updateDate;
    /**
     * create date<p>
     * 创建日期
     */
    @GeneratorColumn(title = "创建日期", order = true)
    private Date createDate;
    /**
     * process date<p>
     * 处理日期
     */
    @GeneratorColumn(title = "处理日期")
    private Date processDate;
    /**
     * payment date<p>
     * 付款日期
     */
    @GeneratorColumn(title = "付款日期")
    private Date paymentDate;

    public TradeOrder() {
    }

    public TradeOrder(short siteId, long userId, String title, BigDecimal amount, String ip, int status, boolean confirmed,
            boolean processed, Date createDate) {
        this.siteId = siteId;
        this.userId = userId;
        this.title = title;
        this.amount = amount;
        this.ip = ip;
        this.status = status;
        this.confirmed = confirmed;
        this.processed = processed;
        this.createDate = createDate;
    }

    public TradeOrder(short siteId, long userId, String title, BigDecimal amount, Long paymentId, String address,
            String addressee, String telephone, String ip, String remark, int status, boolean confirmed, boolean processed,
            long processUserId, String processInfo, Date updateDate, Date createDate, Date processDate, Date paymentDate) {
        this.siteId = siteId;
        this.userId = userId;
        this.title = title;
        this.amount = amount;
        this.paymentId = paymentId;
        this.address = address;
        this.addressee = addressee;
        this.telephone = telephone;
        this.ip = ip;
        this.remark = remark;
        this.status = status;
        this.confirmed = confirmed;
        this.processed = processed;
        this.processUserId = processUserId;
        this.processInfo = processInfo;
        this.updateDate = updateDate;
        this.createDate = createDate;
        this.processDate = processDate;
        this.paymentDate = paymentDate;
    }

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id", unique = true, nullable = false)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "site_id", nullable = false)
    public short getSiteId() {
        return this.siteId;
    }

    public void setSiteId(short siteId) {
        this.siteId = siteId;
    }

    @Column(name = "user_id", nullable = false)
    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    @Column(name = "title", nullable = false)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Column(name = "amount", nullable = false, precision = 10)
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    @Column(name = "payment_id")
    public Long getPaymentId() {
        return this.paymentId;
    }

    public void setPaymentId(Long paymentId) {
        this.paymentId = paymentId;
    }

    @Column(name = "address")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Column(name = "addressee", length = 100)
    public String getAddressee() {
        return this.addressee;
    }

    public void setAddressee(String addressee) {
        this.addressee = addressee;
    }

    @Column(name = "telephone", length = 100)
    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    @Column(name = "ip", nullable = false, length = 130)
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    @Column(name = "remark")
    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Column(name = "status", nullable = false)
    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @Column(name = "confirmed", nullable = false)
    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    @Column(name = "processed", nullable = false)
    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    @Column(name = "process_user_id")
    public Long getProcessUserId() {
        return this.processUserId;
    }

    public void setProcessUserId(Long processUserId) {
        this.processUserId = processUserId;
    }

    @Column(name = "process_info")
    public String getProcessInfo() {
        return this.processInfo;
    }

    public void setProcessInfo(String processInfo) {
        this.processInfo = processInfo;
    }

    @Column(name = "update_date", length = 19)
    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    @Column(name = "create_date", nullable = false, length = 19)
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @Column(name = "process_date", length = 19)
    public Date getProcessDate() {
        return this.processDate;
    }

    public void setProcessDate(Date processDate) {
        this.processDate = processDate;
    }

    @Column(name = "payment_date", length = 19)
    public Date getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(Date paymentDate) {
        this.paymentDate = paymentDate;
    }

}
