package com.publiccms.logic.dao.sys;

import org.springframework.stereotype.Repository;

import com.publiccms.common.base.BaseDao;
import com.publiccms.common.handler.PageHandler;
import com.publiccms.common.handler.QueryHandler;
import com.publiccms.common.tools.CommonUtils;
import com.publiccms.entities.sys.SysDomain;

/**
 *
 * SysDomainDao
 * 
 */
@Repository
public class SysDomainDao extends BaseDao<SysDomain> {

    /**
     * @param siteId
     * @param wild
     * @param pageIndex
     * @param pageSize
     * @return results page
     */
    public PageHandler getPage(Short siteId, Boolean wild, Integer pageIndex, Integer pageSize) {
        QueryHandler queryHandler = getQueryHandler("from SysDomain bean");
        if (CommonUtils.notEmpty(siteId)) {
            queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
        }
        if (null != wild) {
            queryHandler.condition("bean.wild = :wild").setParameter("wild", wild);
        }
        queryHandler.order("bean.id desc");
        return getPage(queryHandler, pageIndex, pageSize);
    }

    /**
     * @param siteId
     * @return results count
     */
    public int deleteBySiteId(Short siteId) {
        if (CommonUtils.notEmpty(siteId)) {
            QueryHandler queryHandler = getQueryHandler("delete from SysDomain bean");
            queryHandler.condition("bean.siteId = :siteId").setParameter("siteId", siteId);
            return delete(queryHandler);
        }
        return 0;
    }

    @Override
    protected SysDomain init(SysDomain entity) {
        return entity;
    }

}