/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;

class ReaderInputStream
extends InputStream {
    private final Reader reader;
    private final Charset charset;
    private final long readerLength;
    private boolean atEndOfStream = false;
    private CharBuffer rawChars = null;
    private static final int MAX_CHAR_BUFFER_SIZE = 4000;
    private ByteBuffer encodedChars = null;
    private final byte[] oneByte = new byte[1];

    ReaderInputStream(Reader reader, String string, long l) throws UnsupportedEncodingException {
        assert (reader != null);
        assert (string != null);
        assert (-1L == l || l >= 0L);
        this.reader = reader;
        try {
            this.charset = Charset.forName(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw new UnsupportedEncodingException(illegalCharsetNameException.getMessage());
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw new UnsupportedEncodingException(unsupportedCharsetException.getMessage());
        }
        this.readerLength = l;
    }

    @Override
    public int available() throws IOException {
        return null == this.encodedChars ? 0 : this.encodedChars.remaining();
    }

    @Override
    public int read() throws IOException {
        return -1 == this.readInternal(this.oneByte, 0, this.oneByte.length) ? -1 : this.oneByte[0];
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.readInternal(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.readInternal(byArray, n, n2);
    }

    private int readInternal(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        assert (null != byArray);
        assert (0 <= n && n <= byArray.length);
        assert (0 <= n2 && n2 <= byArray.length);
        assert (n <= byArray.length - n2);
        if (0 == n2) {
            return 0;
        }
        for (n3 = 0; n3 < n2 && this.encodeChars(); n3 += n4) {
            n4 = this.encodedChars.remaining();
            if (n4 > n2 - n3) {
                n4 = n2 - n3;
            }
            assert (n4 > 0);
            this.encodedChars.get(byArray, n + n3, n4);
        }
        return 0 == n3 && this.atEndOfStream ? -1 : n3;
    }

    private boolean encodeChars() throws IOException {
        if (this.atEndOfStream) {
            return false;
        }
        if (null != this.encodedChars && this.encodedChars.hasRemaining()) {
            return true;
        }
        if (null == this.rawChars || !this.rawChars.hasRemaining()) {
            if (null == this.rawChars) {
                if (0L == this.readerLength) {
                    this.atEndOfStream = true;
                    return false;
                }
                this.rawChars = CharBuffer.allocate(-1L == this.readerLength || this.readerLength > 4000L ? 4000 : (int)this.readerLength);
            } else {
                this.rawChars.clear();
            }
            int n = 0;
            try {
                int n2 = 0;
                while (this.rawChars.hasRemaining() && -1 != (n = this.reader.read(this.rawChars))) {
                    if (n <= 0 || n != this.rawChars.position() - n2) {
                        throw new IOException(SQLServerException.getErrString("R_streamReadReturnedInvalidValue"));
                    }
                    n2 += n;
                }
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
            if (-1 == n && 0 == this.rawChars.position()) {
                this.encodedChars = null;
                this.rawChars = null;
                this.atEndOfStream = true;
                return false;
            }
            this.rawChars.flip();
        }
        if (!this.rawChars.hasRemaining()) {
            return false;
        }
        this.encodedChars = this.charset.encode(this.rawChars);
        return true;
    }
}

