/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.JDBCCallSyntaxTranslator;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.ParameterUtils;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerParameterMetaData;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.StreamSetterArgs;
import com.microsoft.sqlserver.jdbc.StreamType;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.UninterruptableTDSCommand;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.logging.Level;

public class SQLServerPreparedStatement
extends SQLServerStatement
implements PreparedStatement {
    private static final int BATCH_STATEMENT_DELIMITER_TDS_71 = 128;
    private static final int BATCH_STATEMENT_DELIMITER_TDS_72 = 255;
    final int nBatchStatementDelimiter;
    private String sqlCommand;
    private String preparedTypeDefinitions;
    private String preparedSQL;
    final boolean bReturnValueSyntax;
    int outParamIndexAdjustment;
    ArrayList<Parameter[]> batchParamValues;
    private int prepStmtHandle;
    private boolean expectPrepStmtHandle;

    @Override
    final String getPreparedSQL() {
        return this.preparedSQL;
    }

    SQLServerPreparedStatement(SQLServerConnection sQLServerConnection, String string, int n, int n2) throws SQLServerException {
        super(sQLServerConnection, n, n2);
        this.nBatchStatementDelimiter = this.connection.isYukonOrLater() ? 255 : 128;
        this.prepStmtHandle = 0;
        this.expectPrepStmtHandle = false;
        this.sqlCommand = string;
        JDBCCallSyntaxTranslator jDBCCallSyntaxTranslator = new JDBCCallSyntaxTranslator();
        string = jDBCCallSyntaxTranslator.translate(string);
        this.procedureName = jDBCCallSyntaxTranslator.getProcedureName();
        this.bReturnValueSyntax = jDBCCallSyntaxTranslator.hasReturnValueSyntax();
        this.userSQL = string;
        this.initParams(this.userSQL);
    }

    private void closePreparedHandle() throws SQLServerException {
        if (this.connection.isClosed()) {
            return;
        }
        final class PreparedHandleClose
        extends UninterruptableTDSCommand {
            PreparedHandleClose() {
                super("closePreparedHandle");
            }

            @Override
            final boolean doExecute() throws SQLServerException {
                assert (0 != SQLServerPreparedStatement.this.prepStmtHandle);
                TDSWriter tDSWriter = this.startRequest((byte)3);
                tDSWriter.writeShort((short)-1);
                tDSWriter.writeShort(SQLServerPreparedStatement.this.executedSqlDirectly ? (short)15 : 6);
                tDSWriter.writeByte((byte)0);
                tDSWriter.writeByte((byte)0);
                tDSWriter.writeRPCInt(null, new Integer(SQLServerPreparedStatement.this.prepStmtHandle), false);
                SQLServerPreparedStatement.this.prepStmtHandle = 0;
                TDSParser.parse(this.startResponse(), this.getLogContext());
                return true;
            }
        }
        this.executeCommand(new PreparedHandleClose());
    }

    @Override
    public void close() throws SQLServerException {
        block5: {
            loggerExternal.entering(this.getClassNameLogging(), "close");
            if (this.bIsClosed || this.connection.isClosed()) {
                return;
            }
            super.close();
            this.batchParamValues = null;
            if (0 != this.prepStmtHandle) {
                if (this.getStatementLogger().isLoggable(Level.FINER)) {
                    this.getStatementLogger().finer(this.toString() + ": Closing PreparedHandle:" + this.prepStmtHandle);
                }
                try {
                    this.closePreparedHandle();
                }
                catch (SQLServerException sQLServerException) {
                    if (!this.getStatementLogger().isLoggable(Level.WARNING)) break block5;
                    this.getStatementLogger().log(Level.WARNING, this.toString() + ": Error (ignored) closing PreparedHandle:" + this.prepStmtHandle, sQLServerException);
                }
            }
        }
        loggerExternal.exiting(this.getClassNameLogging(), "close");
    }

    final void initParams(String string) {
        int n = 0;
        int n2 = -1;
        while (true) {
            ++n2;
            if ((n2 = ParameterUtils.scanSQLForChar('?', string, n2)) >= string.length()) break;
            ++n;
        }
        this.inOutParam = new Parameter[n];
        for (int i = 0; i < n; ++i) {
            this.inOutParam[i] = new Parameter();
        }
    }

    @Override
    public final void clearParameters() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "clearParameters");
        this.checkClosed();
        if (this.inOutParam == null) {
            return;
        }
        for (int i = 0; i < this.inOutParam.length; ++i) {
            this.inOutParam[i].clearInputValue();
        }
        loggerExternal.exiting(this.getClassNameLogging(), "clearParameters");
    }

    private final boolean buildPreparedStrings(Parameter[] parameterArray) throws SQLServerException {
        String string = this.buildParamTypeDefinitions(parameterArray);
        if (null != this.preparedTypeDefinitions && string.equals(this.preparedTypeDefinitions)) {
            return false;
        }
        this.preparedTypeDefinitions = string;
        this.preparedSQL = this.connection.replaceParameterMarkers(this.userSQL, parameterArray, this.bReturnValueSyntax);
        if (this.bRequestedGeneratedKeys) {
            this.preparedSQL = this.preparedSQL + " select SCOPE_IDENTITY() AS GENERATED_KEYS";
        }
        return true;
    }

    private String buildParamTypeDefinitions(Parameter[] parameterArray) throws SQLServerException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = parameterArray.length;
        char[] cArray = new char[10];
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            int n2 = SQLServerConnection.makeParamName(i, cArray, 0);
            for (int j = 0; j < n2; ++j) {
                stringBuffer.append(cArray[j]);
            }
            stringBuffer.append(' ');
            String string = parameterArray[i].getTypeDefinition(this.connection, this.tdsReader);
            if (null == string) {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_valueNotSetForParameter"));
                Object[] objectArray = new Object[]{new Integer(i + 1)};
                SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, false);
            }
            stringBuffer.append(string);
            if (!parameterArray[i].isOutput()) continue;
            stringBuffer.append(" OUTPUT");
        }
        return stringBuffer.toString();
    }

    @Override
    public ResultSet executeQuery() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "executeQuery");
        this.checkClosed();
        this.executeStatement(new PrepStmtExecCmd(this, 1));
        loggerExternal.exiting(this.getClassNameLogging(), "executeQuery");
        return this.resultSet;
    }

    final ResultSet executeQueryInternal() throws SQLServerException {
        this.checkClosed();
        this.executeStatement(new PrepStmtExecCmd(this, 5));
        return this.resultSet;
    }

    @Override
    public int executeUpdate() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "executeUpdate");
        this.checkClosed();
        this.executeStatement(new PrepStmtExecCmd(this, 2));
        loggerExternal.exiting(this.getClassNameLogging(), "executeUpdate", new Integer(this.updateCount));
        return this.updateCount;
    }

    @Override
    public boolean execute() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "execute");
        this.checkClosed();
        this.executeStatement(new PrepStmtExecCmd(this, 3));
        loggerExternal.exiting(this.getClassNameLogging(), "execute", null != this.resultSet);
        return null != this.resultSet;
    }

    final void doExecutePreparedStatement(PrepStmtExecCmd prepStmtExecCmd) throws SQLServerException {
        this.resetForReexecute();
        if (1 == this.executeMethod || 3 == this.executeMethod) {
            this.connection.setMaxRows(this.maxRows);
            this.connection.setMaxFieldSize(this.maxFieldSize);
        } else {
            assert (2 == this.executeMethod || 4 == this.executeMethod || 5 == this.executeMethod);
            this.connection.setMaxRows(0);
        }
        TDSWriter tDSWriter = prepStmtExecCmd.startRequest((byte)3);
        this.doPrepExec(tDSWriter, this.inOutParam);
        this.tdsReader = prepStmtExecCmd.startResponse(this.getIsResponseBufferingAdaptive());
        this.startResults();
        this.getNextResult();
        if (1 == this.executeMethod && null == this.resultSet) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_noResultset"), null, true);
        } else if (2 == this.executeMethod && null != this.resultSet) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_resultsetGeneratedForUpdate"), null, false);
        }
    }

    @Override
    boolean consumeExecOutParam(TDSReader tDSReader) throws SQLServerException {
        if (!this.expectPrepStmtHandle) {
            return false;
        }
        this.expectPrepStmtHandle = false;
        Parameter parameter = new Parameter();
        parameter.skipRetValStatus(tDSReader);
        this.prepStmtHandle = parameter.getInt(tDSReader);
        parameter.skipValue(tDSReader, true);
        if (this.getStatementLogger().isLoggable(Level.FINER)) {
            this.getStatementLogger().finer(this.toString() + ": Setting PreparedHandle:" + this.prepStmtHandle);
        }
        return true;
    }

    void sendParamsByRPC(TDSWriter tDSWriter, Parameter[] parameterArray) throws SQLServerException {
        for (int i = 0; i < this.inOutParam.length; ++i) {
            parameterArray[i].sendByRPC(tDSWriter, this.connection);
        }
    }

    private final void buildServerCursorPrepExecParams(TDSWriter tDSWriter) throws SQLServerException {
        if (this.getStatementLogger().isLoggable(Level.FINE)) {
            this.getStatementLogger().fine(this.toString() + ": calling sp_cursorprepexec: PreparedHandle:" + this.prepStmtHandle + ", SQL:" + this.preparedSQL);
        }
        this.expectPrepStmtHandle = true;
        this.executedSqlDirectly = false;
        this.expectCursorOutParams = true;
        this.outParamIndexAdjustment = 7;
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)5);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeRPCInt(null, new Integer(this.prepStmtHandle), true);
        this.prepStmtHandle = 0;
        tDSWriter.writeRPCInt(null, new Integer(0), true);
        tDSWriter.writeRPCStringUnicode(this.preparedTypeDefinitions.length() > 0 ? this.preparedTypeDefinitions : null);
        tDSWriter.writeRPCStringUnicode(this.preparedSQL);
        tDSWriter.writeRPCInt(null, new Integer(this.getResultSetScrollOpt() & ~(0 == this.preparedTypeDefinitions.length() ? 4096 : 0)), false);
        tDSWriter.writeRPCInt(null, new Integer(this.getResultSetCCOpt()), false);
        tDSWriter.writeRPCInt(null, new Integer(0), true);
    }

    private final void buildPrepExecParams(TDSWriter tDSWriter) throws SQLServerException {
        if (this.getStatementLogger().isLoggable(Level.FINE)) {
            this.getStatementLogger().fine(this.toString() + ": calling sp_prepexec: PreparedHandle:" + this.prepStmtHandle + ", SQL:" + this.preparedSQL);
        }
        this.expectPrepStmtHandle = true;
        this.executedSqlDirectly = true;
        this.expectCursorOutParams = false;
        this.outParamIndexAdjustment = 3;
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)13);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeRPCInt(null, new Integer(this.prepStmtHandle), true);
        this.prepStmtHandle = 0;
        tDSWriter.writeRPCStringUnicode(this.preparedTypeDefinitions.length() > 0 ? this.preparedTypeDefinitions : null);
        tDSWriter.writeRPCStringUnicode(this.preparedSQL);
    }

    private final void buildServerCursorExecParams(TDSWriter tDSWriter) throws SQLServerException {
        if (this.getStatementLogger().isLoggable(Level.FINE)) {
            this.getStatementLogger().fine(this.toString() + ": calling sp_cursorexecute: PreparedHandle:" + this.prepStmtHandle + ", SQL:" + this.preparedSQL);
        }
        this.expectPrepStmtHandle = false;
        this.executedSqlDirectly = false;
        this.expectCursorOutParams = true;
        this.outParamIndexAdjustment = 5;
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)4);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        assert (0 != this.prepStmtHandle);
        tDSWriter.writeRPCInt(null, new Integer(this.prepStmtHandle), false);
        tDSWriter.writeRPCInt(null, new Integer(0), true);
        tDSWriter.writeRPCInt(null, new Integer(this.getResultSetScrollOpt() & 0xFFFFEFFF), false);
        tDSWriter.writeRPCInt(null, new Integer(this.getResultSetCCOpt()), false);
        tDSWriter.writeRPCInt(null, new Integer(0), true);
    }

    private final void buildExecParams(TDSWriter tDSWriter) throws SQLServerException {
        if (this.getStatementLogger().isLoggable(Level.FINE)) {
            this.getStatementLogger().fine(this.toString() + ": calling sp_execute: PreparedHandle:" + this.prepStmtHandle + ", SQL:" + this.preparedSQL);
        }
        this.expectPrepStmtHandle = false;
        this.executedSqlDirectly = true;
        this.expectCursorOutParams = false;
        this.outParamIndexAdjustment = 1;
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)12);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        assert (0 != this.prepStmtHandle);
        tDSWriter.writeRPCInt(null, new Integer(this.prepStmtHandle), false);
    }

    private final boolean doPrepExec(TDSWriter tDSWriter, Parameter[] parameterArray) throws SQLServerException {
        boolean bl;
        boolean bl2 = bl = this.buildPreparedStrings(parameterArray) || 0 == this.prepStmtHandle;
        if (bl) {
            if (this.isCursorable(this.executeMethod)) {
                this.buildServerCursorPrepExecParams(tDSWriter);
            } else {
                this.buildPrepExecParams(tDSWriter);
            }
        } else if (this.isCursorable(this.executeMethod)) {
            this.buildServerCursorExecParams(tDSWriter);
        } else {
            this.buildExecParams(tDSWriter);
        }
        this.sendParamsByRPC(tDSWriter, parameterArray);
        return bl;
    }

    @Override
    public final ResultSetMetaData getMetaData() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getMetaData");
        this.checkClosed();
        boolean bl = false;
        ResultSetMetaData resultSetMetaData = null;
        try {
            if (this.resultSet != null) {
                this.resultSet.checkClosed();
            }
        }
        catch (SQLServerException sQLServerException) {
            bl = true;
        }
        if (this.resultSet == null || bl) {
            SQLServerResultSet sQLServerResultSet = (SQLServerResultSet)this.buildExecuteMetaData();
            if (null != sQLServerResultSet) {
                resultSetMetaData = sQLServerResultSet.getMetaData();
            }
        } else if (this.resultSet != null) {
            resultSetMetaData = this.resultSet.getMetaData();
        }
        loggerExternal.exiting(this.getClassNameLogging(), "getMetaData", resultSetMetaData);
        return resultSetMetaData;
    }

    private ResultSet buildExecuteMetaData() throws SQLServerException {
        SQLServerResultSet sQLServerResultSet;
        block3: {
            String string = this.sqlCommand;
            if (string.indexOf(123) >= 0) {
                string = new JDBCCallSyntaxTranslator().translate(string);
            }
            sQLServerResultSet = null;
            try {
                string = SQLServerPreparedStatement.replaceMarkerWithNull(string);
                SQLServerStatement sQLServerStatement = (SQLServerStatement)this.connection.createStatement();
                sQLServerResultSet = sQLServerStatement.executeQueryInternal("set fmtonly on " + string + "\nset fmtonly off");
            }
            catch (SQLException sQLException) {
                if (sQLException.getMessage().equals(SQLServerException.getErrString("R_noResultset"))) break block3;
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_processingError"));
                Object[] objectArray = new Object[]{new String(sQLException.getMessage())};
                SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), null, true);
            }
        }
        return sQLServerResultSet;
    }

    final Parameter setterGetParam(int n) throws SQLServerException {
        if (n < 1 || n > this.inOutParam.length) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_indexOutOfRange"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), "07009", false);
        }
        return this.inOutParam[n - 1];
    }

    final void setValue(int n, JDBCType jDBCType, Object object) throws SQLServerException {
        this.setterGetParam(n).setValue(jDBCType, object, null, null, null, this.connection);
    }

    final void setValue(int n, JDBCType jDBCType, Object object, Calendar calendar) throws SQLServerException {
        this.setterGetParam(n).setValue(jDBCType, object, null, calendar, null, this.connection);
    }

    final void setStream(int n, StreamType streamType, Object object, long l) throws SQLServerException {
        this.setterGetParam(n).setValue(streamType.getJDBCType(), object, new StreamSetterArgs(streamType, l), null, null, this.connection);
    }

    @Override
    public final void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setAsciiStream", new Object[]{n, inputStream});
        }
        this.checkClosed();
        this.setStream(n, StreamType.ASCII, inputStream, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setAsciiStream");
    }

    @Override
    public final void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setAsciiStream", new Object[]{n, inputStream, n2});
        }
        this.checkClosed();
        this.setStream(n, StreamType.ASCII, inputStream, n2);
        loggerExternal.exiting(this.getClassNameLogging(), "setAsciiStream");
    }

    @Override
    public final void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setAsciiStream", new Object[]{n, inputStream, l});
        }
        this.checkClosed();
        this.setStream(n, StreamType.ASCII, inputStream, l);
        loggerExternal.exiting(this.getClassNameLogging(), "setAsciiStream");
    }

    private final Parameter getParam(int n) throws SQLServerException {
        if (--n < 0 || n >= this.inOutParam.length) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_indexOutOfRange"));
            Object[] objectArray = new Object[]{new Integer(n + 1)};
            SQLServerException.makeFromDriverError(this.connection, this, messageFormat.format(objectArray), "07009", false);
        }
        return this.inOutParam[n];
    }

    @Override
    public final void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBigDecimal", new Object[]{n, bigDecimal});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.DECIMAL, bigDecimal);
        loggerExternal.exiting(this.getClassNameLogging(), "setBigDecimal");
    }

    @Override
    public final void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBinaryStreaml", new Object[]{n, inputStream});
        }
        this.checkClosed();
        this.setStream(n, StreamType.BINARY, inputStream, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setBinaryStream");
    }

    @Override
    public final void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBinaryStream", new Object[]{n, inputStream, n2});
        }
        this.checkClosed();
        this.setStream(n, StreamType.BINARY, inputStream, n2);
        loggerExternal.exiting(this.getClassNameLogging(), "setBinaryStream");
    }

    @Override
    public final void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBinaryStream", new Object[]{n, inputStream, l});
        }
        this.checkClosed();
        this.setStream(n, StreamType.BINARY, inputStream, l);
        loggerExternal.exiting(this.getClassNameLogging(), "setBinaryStream");
    }

    @Override
    public final void setBoolean(int n, boolean bl) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBoolean", new Object[]{n, bl});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.BIT, bl);
        loggerExternal.exiting(this.getClassNameLogging(), "setBoolean");
    }

    @Override
    public final void setByte(int n, byte by) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setByte", new Object[]{n, by});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.TINYINT, by);
        loggerExternal.exiting(this.getClassNameLogging(), "setByte");
    }

    @Override
    public final void setBytes(int n, byte[] byArray) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBytes", new Object[]{n, byArray});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.BINARY, byArray);
        loggerExternal.exiting(this.getClassNameLogging(), "setBytes");
    }

    @Override
    public final void setDouble(int n, double d) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDouble", new Object[]{n, d});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.DOUBLE, d);
        loggerExternal.exiting(this.getClassNameLogging(), "setDouble");
    }

    @Override
    public final void setFloat(int n, float f) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setFloat", new Object[]{n, Float.valueOf(f)});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.REAL, Float.valueOf(f));
        loggerExternal.exiting(this.getClassNameLogging(), "setFloat");
    }

    @Override
    public final void setInt(int n, int n2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setInt", new Object[]{n, n2});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.INTEGER, n2);
        loggerExternal.exiting(this.getClassNameLogging(), "setInt");
    }

    @Override
    public final void setLong(int n, long l) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setLong", new Object[]{n, l});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.BIGINT, l);
        loggerExternal.exiting(this.getClassNameLogging(), "setLong");
    }

    @Override
    public final void setNull(int n, int n2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNull", new Object[]{n, n2});
        }
        this.checkClosed();
        this.setObject(this.setterGetParam(n), null, JDBCType.of(n2), null);
        loggerExternal.exiting(this.getClassNameLogging(), "setNull");
    }

    final void setObjectNoType(int n, Object object) throws SQLServerException {
        Parameter parameter = this.setterGetParam(n);
        JDBCType jDBCType = parameter.getJdbcType();
        if (null == object) {
            if (JDBCType.UNKNOWN == jDBCType) {
                jDBCType = JDBCType.CHAR;
            }
        } else {
            jDBCType = JDBCType.of(object, jDBCType, SSType.UNKNOWN);
        }
        this.setObject(parameter, object, jDBCType, null);
    }

    @Override
    public final void setObject(int n, Object object) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setObject", new Object[]{n, object});
        }
        this.checkClosed();
        this.setObjectNoType(n, object);
        loggerExternal.exiting(this.getClassNameLogging(), "setObject");
    }

    @Override
    public final void setObject(int n, Object object, int n2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setObject", new Object[]{n, object, n2});
        }
        this.checkClosed();
        this.setObject(this.setterGetParam(n), object, JDBCType.of(n2), null);
        loggerExternal.exiting(this.getClassNameLogging(), "setObject");
    }

    @Override
    public final void setObject(int n, Object object, int n2, int n3) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setObject", new Object[]{n, object, n2, n3});
        }
        this.checkClosed();
        this.setObject(this.setterGetParam(n), object, JDBCType.of(n2), new Integer(n3));
        loggerExternal.exiting(this.getClassNameLogging(), "setObject");
    }

    final void setObject(Parameter parameter, Object object, JDBCType jDBCType, Integer n) throws SQLServerException {
        Object object2;
        assert (JDBCType.UNKNOWN != jDBCType);
        if (null != object) {
            object2 = JDBCType.of(object, jDBCType, SSType.UNKNOWN);
            if (!object2.convertsTo(jDBCType)) {
                DataTypes.throwConversionError(object2.toString(), jDBCType.toString());
            }
        } else if (jDBCType.isUnsupported()) {
            jDBCType = JDBCType.BINARY;
        }
        object2 = null;
        if (Reader.class.isInstance(object)) {
            object2 = new StreamSetterArgs(StreamType.CHARACTER, -1L);
        } else if (InputStream.class.isInstance(object)) {
            object2 = new StreamSetterArgs(jDBCType.isTextual() ? StreamType.CHARACTER : StreamType.BINARY, -1L);
        }
        parameter.setValue(jDBCType, object, (StreamSetterArgs)object2, null, n, this.connection);
    }

    @Override
    public final void setShort(int n, short s) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setShort", new Object[]{n, s});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.SMALLINT, s);
        loggerExternal.exiting(this.getClassNameLogging(), "setShort");
    }

    @Override
    public final void setString(int n, String string) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setString", new Object[]{n, string});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.VARCHAR, string);
        loggerExternal.exiting(this.getClassNameLogging(), "setString");
    }

    @Override
    public final void setNString(int n, String string) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNString", new Object[]{n, string});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.NVARCHAR, string);
        loggerExternal.exiting(this.getClassNameLogging(), "setNString");
    }

    @Override
    public final void setTime(int n, Time time) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTime", new Object[]{n, time});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.TIME, time);
        loggerExternal.exiting(this.getClassNameLogging(), "setTime");
    }

    @Override
    public final void setTimestamp(int n, Timestamp timestamp) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTimestamp", new Object[]{n, timestamp});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.TIMESTAMP, timestamp);
        loggerExternal.exiting(this.getClassNameLogging(), "setTimestamp");
    }

    @Override
    public final void setDate(int n, Date date) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDate", new Object[]{n, date});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.DATE, date);
        loggerExternal.exiting(this.getClassNameLogging(), "setDate");
    }

    @Override
    @Deprecated
    public final void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.NotImplemented();
    }

    @Override
    public final void addBatch() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "addBatch");
        this.checkClosed();
        if (this.batchParamValues == null) {
            this.batchParamValues = new ArrayList();
        }
        int n = this.inOutParam.length;
        Parameter[] parameterArray = new Parameter[n];
        for (int i = 0; i < n; ++i) {
            parameterArray[i] = this.inOutParam[i].cloneForBatch();
        }
        this.batchParamValues.add(parameterArray);
        loggerExternal.exiting(this.getClassNameLogging(), "addBatch");
    }

    @Override
    public final void clearBatch() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "clearBatch");
        this.checkClosed();
        this.batchParamValues = null;
        loggerExternal.exiting(this.getClassNameLogging(), "clearBatch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLServerException, BatchUpdateException {
        int[] nArray;
        loggerExternal.entering(this.getClassNameLogging(), "executeBatch");
        this.checkClosed();
        this.resetForReexecute();
        if (this.batchParamValues == null) {
            nArray = new int[]{};
        } else {
            try {
                for (int i = 0; i < this.batchParamValues.size(); ++i) {
                    Parameter[] parameterArray = this.batchParamValues.get(i);
                    for (int j = 0; j < parameterArray.length; ++j) {
                        if (!parameterArray[j].isOutput()) continue;
                        throw new BatchUpdateException(SQLServerException.getErrString("R_outParamsNotPermittedinBatch"), null, 0, null);
                    }
                }
                PrepStmtBatchExecCmd prepStmtBatchExecCmd = new PrepStmtBatchExecCmd(this);
                this.executeStatement(prepStmtBatchExecCmd);
                if (null != prepStmtBatchExecCmd.batchException) {
                    throw new BatchUpdateException(prepStmtBatchExecCmd.batchException.getMessage(), prepStmtBatchExecCmd.batchException.getSQLState(), prepStmtBatchExecCmd.batchException.getErrorCode(), prepStmtBatchExecCmd.updateCounts);
                }
                nArray = prepStmtBatchExecCmd.updateCounts;
            }
            finally {
                this.batchParamValues = null;
            }
        }
        loggerExternal.exiting(this.getClassNameLogging(), "executeBatch", nArray);
        return nArray;
    }

    final void doExecutePreparedStatementBatch(PrepStmtBatchExecCmd prepStmtBatchExecCmd) throws SQLServerException {
        int n;
        this.executeMethod = 4;
        prepStmtBatchExecCmd.batchException = null;
        int n2 = this.batchParamValues.size();
        prepStmtBatchExecCmd.updateCounts = new int[n2];
        for (n = 0; n < n2; ++n) {
            prepStmtBatchExecCmd.updateCounts[n] = -3;
        }
        n = 0;
        int n3 = 0;
        if (this.isSelect(this.userSQL)) {
            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_selectNotPermittedinBatch"), null, true);
        }
        this.connection.setMaxRows(0);
        Parameter[] parameterArray = new Parameter[this.inOutParam.length];
        TDSWriter tDSWriter = null;
        while (n3 < n2) {
            Parameter[] parameterArray2 = this.batchParamValues.get(n);
            assert (parameterArray2.length == parameterArray.length);
            for (int i = 0; i < parameterArray2.length; ++i) {
                parameterArray[i] = parameterArray2[i];
            }
            if (n3 < n) {
                tDSWriter.writeByte((byte)this.nBatchStatementDelimiter);
            } else {
                tDSWriter = prepStmtBatchExecCmd.startRequest((byte)3);
            }
            if (!this.doPrepExec(tDSWriter, parameterArray) && ++n != n2) continue;
            this.tdsReader = prepStmtBatchExecCmd.startResponse(this.getIsResponseBufferingAdaptive());
            while (n3 < n) {
                block14: {
                    this.startResults();
                    try {
                        if (!this.getNextResult()) {
                            return;
                        }
                        if (null != this.resultSet) {
                            SQLServerException.makeFromDriverError(this.connection, this, SQLServerException.getErrString("R_resultsetGeneratedForUpdate"), null, false);
                        }
                    }
                    catch (SQLServerException sQLServerException) {
                        if (this.connection.isClosed() || this.connection.rolledBackTransaction()) {
                            throw sQLServerException;
                        }
                        this.updateCount = -3;
                        if (null != prepStmtBatchExecCmd.batchException) break block14;
                        prepStmtBatchExecCmd.batchException = sQLServerException;
                    }
                }
                prepStmtBatchExecCmd.updateCounts[n3++] = -1 == this.updateCount ? -2 : this.updateCount;
                this.processBatch();
            }
            assert (n3 == n);
        }
    }

    @Override
    public final void setCharacterStream(int n, Reader reader) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setCharacterStream", new Object[]{n, reader});
        }
        this.checkClosed();
        this.setStream(n, StreamType.CHARACTER, reader, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setCharacterStream");
    }

    @Override
    public final void setCharacterStream(int n, Reader reader, int n2) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setCharacterStream", new Object[]{n, reader, n2});
        }
        this.checkClosed();
        this.setStream(n, StreamType.CHARACTER, reader, n2);
        loggerExternal.exiting(this.getClassNameLogging(), "setCharacterStream");
    }

    @Override
    public final void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setCharacterStream", new Object[]{n, reader, l});
        }
        this.checkClosed();
        this.setStream(n, StreamType.CHARACTER, reader, l);
        loggerExternal.exiting(this.getClassNameLogging(), "setCharacterStream");
    }

    @Override
    public final void setNCharacterStream(int n, Reader reader) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNCharacterStream", new Object[]{n, reader});
        }
        this.checkClosed();
        this.setStream(n, StreamType.NCHARACTER, reader, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setNCharacterStream");
    }

    @Override
    public final void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNCharacterStream", new Object[]{n, reader, l});
        }
        this.checkClosed();
        this.setStream(n, StreamType.NCHARACTER, reader, l);
        loggerExternal.exiting(this.getClassNameLogging(), "setNCharacterStream");
    }

    @Override
    public final void setRef(int n, Ref ref) throws SQLServerException {
        this.NotImplemented();
    }

    @Override
    public final void setBlob(int n, Blob blob) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBlob", new Object[]{n, blob});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.BLOB, blob);
        loggerExternal.exiting(this.getClassNameLogging(), "setBlob");
    }

    @Override
    public final void setBlob(int n, InputStream inputStream) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBlob", new Object[]{n, inputStream});
        }
        this.checkClosed();
        this.setStream(n, StreamType.BINARY, inputStream, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setBlob");
    }

    @Override
    public final void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setBlob", new Object[]{n, inputStream, l});
        }
        this.checkClosed();
        this.setStream(n, StreamType.BINARY, inputStream, l);
        loggerExternal.exiting(this.getClassNameLogging(), "setBlob");
    }

    @Override
    public final void setClob(int n, Clob clob) throws SQLException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setClob", new Object[]{n, clob});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.CLOB, clob);
        loggerExternal.exiting(this.getClassNameLogging(), "setClob");
    }

    @Override
    public final void setClob(int n, Reader reader) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setClob", new Object[]{n, reader});
        }
        this.checkClosed();
        this.setStream(n, StreamType.CHARACTER, reader, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setClob");
    }

    @Override
    public final void setClob(int n, Reader reader, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setClob", new Object[]{n, reader, l});
        }
        this.checkClosed();
        this.setStream(n, StreamType.CHARACTER, reader, l);
        loggerExternal.exiting(this.getClassNameLogging(), "setClob");
    }

    @Override
    public final void setNClob(int n, NClob nClob) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNClob", new Object[]{n, nClob});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.NCLOB, nClob);
        loggerExternal.exiting(this.getClassNameLogging(), "setNClob");
    }

    @Override
    public final void setNClob(int n, Reader reader) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNClob", new Object[]{n, reader});
        }
        this.checkClosed();
        this.setStream(n, StreamType.NCHARACTER, reader, -1L);
        loggerExternal.exiting(this.getClassNameLogging(), "setNClob");
    }

    @Override
    public final void setNClob(int n, Reader reader, long l) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNClob", new Object[]{n, reader, l});
        }
        this.checkClosed();
        this.setStream(n, StreamType.NCHARACTER, reader, l);
        loggerExternal.exiting(this.getClassNameLogging(), "setNClob");
    }

    @Override
    public final void setArray(int n, Array array) throws SQLServerException {
        this.NotImplemented();
    }

    @Override
    public final void setDate(int n, Date date, Calendar calendar) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setDate", new Object[]{n, date, calendar});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.DATE, date, calendar);
        loggerExternal.exiting(this.getClassNameLogging(), "setDate");
    }

    @Override
    public final void setTime(int n, Time time, Calendar calendar) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTime", new Object[]{n, time, calendar});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.TIME, time, calendar);
        loggerExternal.exiting(this.getClassNameLogging(), "setTime");
    }

    @Override
    public final void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setTimestamp", new Object[]{n, timestamp, calendar});
        }
        this.checkClosed();
        this.setValue(n, JDBCType.TIMESTAMP, timestamp, calendar);
        loggerExternal.exiting(this.getClassNameLogging(), "setTimestamp");
    }

    @Override
    public final void setNull(int n, int n2, String string) throws SQLServerException {
        if (loggerExternal.isLoggable(Level.FINER)) {
            loggerExternal.entering(this.getClassNameLogging(), "setNull", new Object[]{n, n2, string});
        }
        this.checkClosed();
        this.setObject(this.setterGetParam(n), null, JDBCType.of(n2), null);
        loggerExternal.exiting(this.getClassNameLogging(), "setNull");
    }

    @Override
    public final ParameterMetaData getParameterMetaData() throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "getParameterMetaData");
        this.checkClosed();
        SQLServerParameterMetaData sQLServerParameterMetaData = new SQLServerParameterMetaData(this, this.userSQL);
        loggerExternal.exiting(this.getClassNameLogging(), "getParameterMetaData", sQLServerParameterMetaData);
        return sQLServerParameterMetaData;
    }

    @Override
    public final void setURL(int n, URL uRL) throws SQLServerException {
        this.NotImplemented();
    }

    @Override
    public final void setRowId(int n, RowId rowId) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public final void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        throw new SQLFeatureNotSupportedException(SQLServerException.getErrString("R_notSupported"));
    }

    @Override
    public final int executeUpdate(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "executeUpdate", string);
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_cannotTakeArgumentsPreparedOrCallable"));
        Object[] objectArray = new Object[]{new String("executeUpdate()")};
        throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
    }

    @Override
    public final boolean execute(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "execute", string);
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_cannotTakeArgumentsPreparedOrCallable"));
        Object[] objectArray = new Object[]{new String("execute()")};
        throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
    }

    @Override
    public final ResultSet executeQuery(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "executeQuery", string);
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_cannotTakeArgumentsPreparedOrCallable"));
        Object[] objectArray = new Object[]{new String("executeQuery()")};
        throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
    }

    @Override
    public void addBatch(String string) throws SQLServerException {
        loggerExternal.entering(this.getClassNameLogging(), "addBatch", string);
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_cannotTakeArgumentsPreparedOrCallable"));
        Object[] objectArray = new Object[]{new String("addBatch()")};
        throw new SQLServerException((Object)this, messageFormat.format(objectArray), null, 0, false);
    }

    private final class PrepStmtBatchExecCmd
    extends TDSCommand {
        private final SQLServerPreparedStatement stmt;
        SQLServerException batchException;
        int[] updateCounts;

        PrepStmtBatchExecCmd(SQLServerPreparedStatement sQLServerPreparedStatement2) {
            super(sQLServerPreparedStatement2.toString() + " executeBatch", SQLServerPreparedStatement.this.queryTimeout);
            this.stmt = sQLServerPreparedStatement2;
        }

        @Override
        final boolean doExecute() throws SQLServerException {
            this.stmt.doExecutePreparedStatementBatch(this);
            return true;
        }

        @Override
        final void processResponse(TDSReader tDSReader) throws SQLServerException {
            SQLServerPreparedStatement.this.processExecuteResults(tDSReader);
        }
    }

    private final class PrepStmtExecCmd
    extends TDSCommand {
        private final SQLServerPreparedStatement stmt;

        PrepStmtExecCmd(SQLServerPreparedStatement sQLServerPreparedStatement2, int n) {
            super(sQLServerPreparedStatement2.toString() + " executeXXX", SQLServerPreparedStatement.this.queryTimeout);
            this.stmt = sQLServerPreparedStatement2;
            sQLServerPreparedStatement2.executeMethod = n;
        }

        @Override
        final boolean doExecute() throws SQLServerException {
            this.stmt.doExecutePreparedStatement(this);
            return false;
        }

        @Override
        final void processResponse(TDSReader tDSReader) throws SQLServerException {
            SQLServerPreparedStatement.this.processExecuteResults(tDSReader);
        }
    }
}

